<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/transaction.proto

namespace Google\Cloud\Spanner\V1\TransactionOptions;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message type to initiate a read-only transaction.
 *
 * Generated from protobuf message <code>google.spanner.v1.TransactionOptions.ReadOnly</code>
 */
class ReadOnly extends \Google\Protobuf\Internal\Message
{
    /**
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     *
     * Generated from protobuf field <code>bool return_read_timestamp = 6;</code>
     */
    private $return_read_timestamp = false;
    protected $timestamp_bound;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $strong
     *           Read at a timestamp where all previously committed transactions
     *           are visible.
     *     @type \Google\Protobuf\Timestamp $min_read_timestamp
     *           Executes all reads at a timestamp >= `min_read_timestamp`.
     *           This is useful for requesting fresher data than some previous
     *           read, or data that is fresh enough to observe the effects of some
     *           previously committed transaction whose timestamp is known.
     *           Note that this option can only be used in single-use transactions.
     *           A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     *           Example: `"2014-10-02T15:01:23.045123456Z"`.
     *     @type \Google\Protobuf\Duration $max_staleness
     *           Read data at a timestamp >= `NOW - max_staleness`
     *           seconds. Guarantees that all writes that have committed more
     *           than the specified number of seconds ago are visible. Because
     *           Cloud Spanner chooses the exact timestamp, this mode works even if
     *           the client's local clock is substantially skewed from Cloud Spanner
     *           commit timestamps.
     *           Useful for reading the freshest data available at a nearby
     *           replica, while bounding the possible staleness if the local
     *           replica has fallen behind.
     *           Note that this option can only be used in single-use
     *           transactions.
     *     @type \Google\Protobuf\Timestamp $read_timestamp
     *           Executes all reads at the given timestamp. Unlike other modes,
     *           reads at a specific timestamp are repeatable; the same read at
     *           the same timestamp always returns the same data. If the
     *           timestamp is in the future, the read will block until the
     *           specified timestamp, modulo the read's deadline.
     *           Useful for large scale consistent reads such as mapreduces, or
     *           for coordinating many reads against a consistent snapshot of the
     *           data.
     *           A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     *           Example: `"2014-10-02T15:01:23.045123456Z"`.
     *     @type \Google\Protobuf\Duration $exact_staleness
     *           Executes all reads at a timestamp that is `exact_staleness`
     *           old. The timestamp is chosen soon after the read is started.
     *           Guarantees that all writes that have committed more than the
     *           specified number of seconds ago are visible. Because Cloud Spanner
     *           chooses the exact timestamp, this mode works even if the client's
     *           local clock is substantially skewed from Cloud Spanner commit
     *           timestamps.
     *           Useful for reading at nearby replicas without the distributed
     *           timestamp negotiation overhead of `max_staleness`.
     *     @type bool $return_read_timestamp
     *           If true, the Cloud Spanner-selected read timestamp is included in
     *           the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Transaction::initOnce();
        parent::__construct($data);
    }

    /**
     * Read at a timestamp where all previously committed transactions
     * are visible.
     *
     * Generated from protobuf field <code>bool strong = 1;</code>
     * @return bool
     */
    public function getStrong()
    {
        return $this->readOneof(1);
    }

    public function hasStrong()
    {
        return $this->hasOneof(1);
    }

    /**
     * Read at a timestamp where all previously committed transactions
     * are visible.
     *
     * Generated from protobuf field <code>bool strong = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setStrong($var)
    {
        GPBUtil::checkBool($var);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Executes all reads at a timestamp >= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getMinReadTimestamp()
    {
        return $this->readOneof(2);
    }

    public function hasMinReadTimestamp()
    {
        return $this->hasOneof(2);
    }

    /**
     * Executes all reads at a timestamp >= `min_read_timestamp`.
     * This is useful for requesting fresher data than some previous
     * read, or data that is fresh enough to observe the effects of some
     * previously committed transaction whose timestamp is known.
     * Note that this option can only be used in single-use transactions.
     * A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp min_read_timestamp = 2;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setMinReadTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Read data at a timestamp >= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_staleness = 3;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMaxStaleness()
    {
        return $this->readOneof(3);
    }

    public function hasMaxStaleness()
    {
        return $this->hasOneof(3);
    }

    /**
     * Read data at a timestamp >= `NOW - max_staleness`
     * seconds. Guarantees that all writes that have committed more
     * than the specified number of seconds ago are visible. Because
     * Cloud Spanner chooses the exact timestamp, this mode works even if
     * the client's local clock is substantially skewed from Cloud Spanner
     * commit timestamps.
     * Useful for reading the freshest data available at a nearby
     * replica, while bounding the possible staleness if the local
     * replica has fallen behind.
     * Note that this option can only be used in single-use
     * transactions.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration max_staleness = 3;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMaxStaleness($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getReadTimestamp()
    {
        return $this->readOneof(4);
    }

    public function hasReadTimestamp()
    {
        return $this->hasOneof(4);
    }

    /**
     * Executes all reads at the given timestamp. Unlike other modes,
     * reads at a specific timestamp are repeatable; the same read at
     * the same timestamp always returns the same data. If the
     * timestamp is in the future, the read will block until the
     * specified timestamp, modulo the read's deadline.
     * Useful for large scale consistent reads such as mapreduces, or
     * for coordinating many reads against a consistent snapshot of the
     * data.
     * A timestamp in RFC3339 UTC \"Zulu\" format, accurate to nanoseconds.
     * Example: `"2014-10-02T15:01:23.045123456Z"`.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp read_timestamp = 4;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setReadTimestamp($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration exact_staleness = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getExactStaleness()
    {
        return $this->readOneof(5);
    }

    public function hasExactStaleness()
    {
        return $this->hasOneof(5);
    }

    /**
     * Executes all reads at a timestamp that is `exact_staleness`
     * old. The timestamp is chosen soon after the read is started.
     * Guarantees that all writes that have committed more than the
     * specified number of seconds ago are visible. Because Cloud Spanner
     * chooses the exact timestamp, this mode works even if the client's
     * local clock is substantially skewed from Cloud Spanner commit
     * timestamps.
     * Useful for reading at nearby replicas without the distributed
     * timestamp negotiation overhead of `max_staleness`.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration exact_staleness = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setExactStaleness($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     *
     * Generated from protobuf field <code>bool return_read_timestamp = 6;</code>
     * @return bool
     */
    public function getReturnReadTimestamp()
    {
        return $this->return_read_timestamp;
    }

    /**
     * If true, the Cloud Spanner-selected read timestamp is included in
     * the [Transaction][google.spanner.v1.Transaction] message that describes the transaction.
     *
     * Generated from protobuf field <code>bool return_read_timestamp = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setReturnReadTimestamp($var)
    {
        GPBUtil::checkBool($var);
        $this->return_read_timestamp = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTimestampBound()
    {
        return $this->whichOneof("timestamp_bound");
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ReadOnly::class, \Google\Cloud\Spanner\V1\TransactionOptions_ReadOnly::class);

