<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/service.proto

namespace Google\Cloud\Monitoring\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Service-Level Indicator (SLI) describes the "performance" of a service. For
 * some services, the SLI is well-defined. In such cases, the SLI can be
 * described easily by referencing the well-known SLI and providing the needed
 * parameters. Alternatively, a "custom" SLI can be defined with a query to the
 * underlying metric store. An SLI is defined to be `good_service /
 * total_service` over any queried time interval. The value of performance
 * always falls into the range `0 <= performance <= 1`. A custom SLI describes
 * how to compute this ratio, whether this is by dividing values from a pair of
 * time series, cutting a `Distribution` into good and bad counts, or counting
 * time windows in which the service complies with a criterion. For separation
 * of concerns, a single Service-Level Indicator measures performance for only
 * one aspect of service quality, such as fraction of successful queries or
 * fast-enough queries.
 *
 * Generated from protobuf message <code>google.monitoring.v3.ServiceLevelIndicator</code>
 */
class ServiceLevelIndicator extends \Google\Protobuf\Internal\Message
{
    protected $type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\Monitoring\V3\BasicSli $basic_sli
     *           Basic SLI on a well-known service type.
     *     @type \Google\Cloud\Monitoring\V3\RequestBasedSli $request_based
     *           Request-based SLIs
     *     @type \Google\Cloud\Monitoring\V3\WindowsBasedSli $windows_based
     *           Windows-based SLIs
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Service::initOnce();
        parent::__construct($data);
    }

    /**
     * Basic SLI on a well-known service type.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     * @return \Google\Cloud\Monitoring\V3\BasicSli
     */
    public function getBasicSli()
    {
        return $this->readOneof(4);
    }

    /**
     * Basic SLI on a well-known service type.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.BasicSli basic_sli = 4;</code>
     * @param \Google\Cloud\Monitoring\V3\BasicSli $var
     * @return $this
     */
    public function setBasicSli($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\BasicSli::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Request-based SLIs
     *
     * Generated from protobuf field <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     * @return \Google\Cloud\Monitoring\V3\RequestBasedSli
     */
    public function getRequestBased()
    {
        return $this->readOneof(1);
    }

    /**
     * Request-based SLIs
     *
     * Generated from protobuf field <code>.google.monitoring.v3.RequestBasedSli request_based = 1;</code>
     * @param \Google\Cloud\Monitoring\V3\RequestBasedSli $var
     * @return $this
     */
    public function setRequestBased($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\RequestBasedSli::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Windows-based SLIs
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     * @return \Google\Cloud\Monitoring\V3\WindowsBasedSli
     */
    public function getWindowsBased()
    {
        return $this->readOneof(2);
    }

    /**
     * Windows-based SLIs
     *
     * Generated from protobuf field <code>.google.monitoring.v3.WindowsBasedSli windows_based = 2;</code>
     * @param \Google\Cloud\Monitoring\V3\WindowsBasedSli $var
     * @return $this
     */
    public function setWindowsBased($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\WindowsBasedSli::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->whichOneof("type");
    }

}

