<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/billing/v1/cloud_catalog.proto

namespace Google\Cloud\Billing\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the pricing information for a SKU at a single point of time.
 *
 * Generated from protobuf message <code>google.cloud.billing.v1.PricingInfo</code>
 */
class PricingInfo extends \Google\Protobuf\Internal\Message
{
    /**
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp effective_time = 1;</code>
     */
    private $effective_time = null;
    /**
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     *
     * Generated from protobuf field <code>string summary = 2;</code>
     */
    private $summary = '';
    /**
     * Expresses the pricing formula. See `PricingExpression` for an example.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     */
    private $pricing_expression = null;
    /**
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     */
    private $aggregation_info = null;
    /**
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     *
     * Generated from protobuf field <code>double currency_conversion_rate = 5;</code>
     */
    private $currency_conversion_rate = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Timestamp $effective_time
     *           The timestamp from which this pricing was effective within the requested
     *           time range. This is guaranteed to be greater than or equal to the
     *           start_time field in the request and less than the end_time field in the
     *           request. If a time range was not specified in the request this field will
     *           be equivalent to a time within the last 12 hours, indicating the latest
     *           pricing info.
     *     @type string $summary
     *           An optional human readable summary of the pricing information, has a
     *           maximum length of 256 characters.
     *     @type \Google\Cloud\Billing\V1\PricingExpression $pricing_expression
     *           Expresses the pricing formula. See `PricingExpression` for an example.
     *     @type \Google\Cloud\Billing\V1\AggregationInfo $aggregation_info
     *           Aggregation Info. This can be left unspecified if the pricing expression
     *           doesn't require aggregation.
     *     @type float $currency_conversion_rate
     *           Conversion rate used for currency conversion, from USD to the currency
     *           specified in the request. This includes any surcharge collected for billing
     *           in non USD currency. If a currency is not specified in the request this
     *           defaults to 1.0.
     *           Example: USD * currency_conversion_rate = JPY
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Billing\V1\CloudCatalog::initOnce();
        parent::__construct($data);
    }

    /**
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp effective_time = 1;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEffectiveTime()
    {
        return isset($this->effective_time) ? $this->effective_time : null;
    }

    public function hasEffectiveTime()
    {
        return isset($this->effective_time);
    }

    public function clearEffectiveTime()
    {
        unset($this->effective_time);
    }

    /**
     * The timestamp from which this pricing was effective within the requested
     * time range. This is guaranteed to be greater than or equal to the
     * start_time field in the request and less than the end_time field in the
     * request. If a time range was not specified in the request this field will
     * be equivalent to a time within the last 12 hours, indicating the latest
     * pricing info.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp effective_time = 1;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEffectiveTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->effective_time = $var;

        return $this;
    }

    /**
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     *
     * Generated from protobuf field <code>string summary = 2;</code>
     * @return string
     */
    public function getSummary()
    {
        return $this->summary;
    }

    /**
     * An optional human readable summary of the pricing information, has a
     * maximum length of 256 characters.
     *
     * Generated from protobuf field <code>string summary = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setSummary($var)
    {
        GPBUtil::checkString($var, True);
        $this->summary = $var;

        return $this;
    }

    /**
     * Expresses the pricing formula. See `PricingExpression` for an example.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     * @return \Google\Cloud\Billing\V1\PricingExpression|null
     */
    public function getPricingExpression()
    {
        return isset($this->pricing_expression) ? $this->pricing_expression : null;
    }

    public function hasPricingExpression()
    {
        return isset($this->pricing_expression);
    }

    public function clearPricingExpression()
    {
        unset($this->pricing_expression);
    }

    /**
     * Expresses the pricing formula. See `PricingExpression` for an example.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.PricingExpression pricing_expression = 3;</code>
     * @param \Google\Cloud\Billing\V1\PricingExpression $var
     * @return $this
     */
    public function setPricingExpression($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Billing\V1\PricingExpression::class);
        $this->pricing_expression = $var;

        return $this;
    }

    /**
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     * @return \Google\Cloud\Billing\V1\AggregationInfo|null
     */
    public function getAggregationInfo()
    {
        return isset($this->aggregation_info) ? $this->aggregation_info : null;
    }

    public function hasAggregationInfo()
    {
        return isset($this->aggregation_info);
    }

    public function clearAggregationInfo()
    {
        unset($this->aggregation_info);
    }

    /**
     * Aggregation Info. This can be left unspecified if the pricing expression
     * doesn't require aggregation.
     *
     * Generated from protobuf field <code>.google.cloud.billing.v1.AggregationInfo aggregation_info = 4;</code>
     * @param \Google\Cloud\Billing\V1\AggregationInfo $var
     * @return $this
     */
    public function setAggregationInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Billing\V1\AggregationInfo::class);
        $this->aggregation_info = $var;

        return $this;
    }

    /**
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     *
     * Generated from protobuf field <code>double currency_conversion_rate = 5;</code>
     * @return float
     */
    public function getCurrencyConversionRate()
    {
        return $this->currency_conversion_rate;
    }

    /**
     * Conversion rate used for currency conversion, from USD to the currency
     * specified in the request. This includes any surcharge collected for billing
     * in non USD currency. If a currency is not specified in the request this
     * defaults to 1.0.
     * Example: USD * currency_conversion_rate = JPY
     *
     * Generated from protobuf field <code>double currency_conversion_rate = 5;</code>
     * @param float $var
     * @return $this
     */
    public function setCurrencyConversionRate($var)
    {
        GPBUtil::checkDouble($var);
        $this->currency_conversion_rate = $var;

        return $this;
    }

}

