<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The request for [Read][google.spanner.v1.Spanner.Read] and
 * [StreamingRead][google.spanner.v1.Spanner.StreamingRead].
 *
 * Generated from protobuf message <code>google.spanner.v1.ReadRequest</code>
 */
class ReadRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The session in which the read should be performed.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    private $session = '';
    /**
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     */
    private $transaction = null;
    /**
     * Required. The name of the table in the database to be read.
     *
     * Generated from protobuf field <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $table = '';
    /**
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     *
     * Generated from protobuf field <code>string index = 4;</code>
     */
    private $index = '';
    /**
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     *
     * Generated from protobuf field <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $columns;
    /**
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     *
     * Generated from protobuf field <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $key_set = null;
    /**
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     *
     * Generated from protobuf field <code>int64 limit = 8;</code>
     */
    private $limit = 0;
    /**
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     *
     * Generated from protobuf field <code>bytes resume_token = 9;</code>
     */
    private $resume_token = '';
    /**
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     *
     * Generated from protobuf field <code>bytes partition_token = 10;</code>
     */
    private $partition_token = '';
    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     */
    private $request_options = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $session
     *           Required. The session in which the read should be performed.
     *     @type \Google\Cloud\Spanner\V1\TransactionSelector $transaction
     *           The transaction to use. If none is provided, the default is a
     *           temporary read-only transaction with strong concurrency.
     *     @type string $table
     *           Required. The name of the table in the database to be read.
     *     @type string $index
     *           If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     *           used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     *           and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $columns
     *           Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     *           this request.
     *     @type \Google\Cloud\Spanner\V1\KeySet $key_set
     *           Required. `key_set` identifies the rows to be yielded. `key_set` names the
     *           primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     *           is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     *           index keys in [index][google.spanner.v1.ReadRequest.index].
     *           If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     *           in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     *           (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     *           empty, rows will be yielded in an unspecified order.
     *           It is not an error for the `key_set` to name rows that do not
     *           exist in the database. Read yields nothing for nonexistent rows.
     *     @type int|string $limit
     *           If greater than zero, only the first `limit` rows are yielded. If `limit`
     *           is zero, the default is no limit. A limit cannot be specified if
     *           `partition_token` is set.
     *     @type string $resume_token
     *           If this request is resuming a previously interrupted read,
     *           `resume_token` should be copied from the last
     *           [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     *           enables the new read to resume where the last read left off. The
     *           rest of the request parameters must exactly match the request
     *           that yielded this token.
     *     @type string $partition_token
     *           If present, results will be restricted to the specified partition
     *           previously created using PartitionRead().    There must be an exact
     *           match for the values of fields common to this message and the
     *           PartitionReadRequest message used to create this partition_token.
     *     @type \Google\Cloud\Spanner\V1\RequestOptions $request_options
     *           Common options for this request.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Spanner\V1\Spanner::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The session in which the read should be performed.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSession()
    {
        return $this->session;
    }

    /**
     * Required. The session in which the read should be performed.
     *
     * Generated from protobuf field <code>string session = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSession($var)
    {
        GPBUtil::checkString($var, True);
        $this->session = $var;

        return $this;
    }

    /**
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     * @return \Google\Cloud\Spanner\V1\TransactionSelector|null
     */
    public function getTransaction()
    {
        return isset($this->transaction) ? $this->transaction : null;
    }

    public function hasTransaction()
    {
        return isset($this->transaction);
    }

    public function clearTransaction()
    {
        unset($this->transaction);
    }

    /**
     * The transaction to use. If none is provided, the default is a
     * temporary read-only transaction with strong concurrency.
     *
     * Generated from protobuf field <code>.google.spanner.v1.TransactionSelector transaction = 2;</code>
     * @param \Google\Cloud\Spanner\V1\TransactionSelector $var
     * @return $this
     */
    public function setTransaction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\TransactionSelector::class);
        $this->transaction = $var;

        return $this;
    }

    /**
     * Required. The name of the table in the database to be read.
     *
     * Generated from protobuf field <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTable()
    {
        return $this->table;
    }

    /**
     * Required. The name of the table in the database to be read.
     *
     * Generated from protobuf field <code>string table = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTable($var)
    {
        GPBUtil::checkString($var, True);
        $this->table = $var;

        return $this;
    }

    /**
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     *
     * Generated from protobuf field <code>string index = 4;</code>
     * @return string
     */
    public function getIndex()
    {
        return $this->index;
    }

    /**
     * If non-empty, the name of an index on [table][google.spanner.v1.ReadRequest.table]. This index is
     * used instead of the table primary key when interpreting [key_set][google.spanner.v1.ReadRequest.key_set]
     * and sorting result rows. See [key_set][google.spanner.v1.ReadRequest.key_set] for further information.
     *
     * Generated from protobuf field <code>string index = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setIndex($var)
    {
        GPBUtil::checkString($var, True);
        $this->index = $var;

        return $this;
    }

    /**
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     *
     * Generated from protobuf field <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getColumns()
    {
        return $this->columns;
    }

    /**
     * Required. The columns of [table][google.spanner.v1.ReadRequest.table] to be returned for each row matching
     * this request.
     *
     * Generated from protobuf field <code>repeated string columns = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setColumns($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->columns = $arr;

        return $this;
    }

    /**
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     *
     * Generated from protobuf field <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Spanner\V1\KeySet|null
     */
    public function getKeySet()
    {
        return isset($this->key_set) ? $this->key_set : null;
    }

    public function hasKeySet()
    {
        return isset($this->key_set);
    }

    public function clearKeySet()
    {
        unset($this->key_set);
    }

    /**
     * Required. `key_set` identifies the rows to be yielded. `key_set` names the
     * primary keys of the rows in [table][google.spanner.v1.ReadRequest.table] to be yielded, unless [index][google.spanner.v1.ReadRequest.index]
     * is present. If [index][google.spanner.v1.ReadRequest.index] is present, then [key_set][google.spanner.v1.ReadRequest.key_set] instead names
     * index keys in [index][google.spanner.v1.ReadRequest.index].
     * If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is empty, rows are yielded
     * in table primary key order (if [index][google.spanner.v1.ReadRequest.index] is empty) or index key order
     * (if [index][google.spanner.v1.ReadRequest.index] is non-empty).  If the [partition_token][google.spanner.v1.ReadRequest.partition_token] field is not
     * empty, rows will be yielded in an unspecified order.
     * It is not an error for the `key_set` to name rows that do not
     * exist in the database. Read yields nothing for nonexistent rows.
     *
     * Generated from protobuf field <code>.google.spanner.v1.KeySet key_set = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Spanner\V1\KeySet $var
     * @return $this
     */
    public function setKeySet($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\KeySet::class);
        $this->key_set = $var;

        return $this;
    }

    /**
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     *
     * Generated from protobuf field <code>int64 limit = 8;</code>
     * @return int|string
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * If greater than zero, only the first `limit` rows are yielded. If `limit`
     * is zero, the default is no limit. A limit cannot be specified if
     * `partition_token` is set.
     *
     * Generated from protobuf field <code>int64 limit = 8;</code>
     * @param int|string $var
     * @return $this
     */
    public function setLimit($var)
    {
        GPBUtil::checkInt64($var);
        $this->limit = $var;

        return $this;
    }

    /**
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     *
     * Generated from protobuf field <code>bytes resume_token = 9;</code>
     * @return string
     */
    public function getResumeToken()
    {
        return $this->resume_token;
    }

    /**
     * If this request is resuming a previously interrupted read,
     * `resume_token` should be copied from the last
     * [PartialResultSet][google.spanner.v1.PartialResultSet] yielded before the interruption. Doing this
     * enables the new read to resume where the last read left off. The
     * rest of the request parameters must exactly match the request
     * that yielded this token.
     *
     * Generated from protobuf field <code>bytes resume_token = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setResumeToken($var)
    {
        GPBUtil::checkString($var, False);
        $this->resume_token = $var;

        return $this;
    }

    /**
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     *
     * Generated from protobuf field <code>bytes partition_token = 10;</code>
     * @return string
     */
    public function getPartitionToken()
    {
        return $this->partition_token;
    }

    /**
     * If present, results will be restricted to the specified partition
     * previously created using PartitionRead().    There must be an exact
     * match for the values of fields common to this message and the
     * PartitionReadRequest message used to create this partition_token.
     *
     * Generated from protobuf field <code>bytes partition_token = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setPartitionToken($var)
    {
        GPBUtil::checkString($var, False);
        $this->partition_token = $var;

        return $this;
    }

    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     * @return \Google\Cloud\Spanner\V1\RequestOptions|null
     */
    public function getRequestOptions()
    {
        return isset($this->request_options) ? $this->request_options : null;
    }

    public function hasRequestOptions()
    {
        return isset($this->request_options);
    }

    public function clearRequestOptions()
    {
        unset($this->request_options);
    }

    /**
     * Common options for this request.
     *
     * Generated from protobuf field <code>.google.spanner.v1.RequestOptions request_options = 11;</code>
     * @param \Google\Cloud\Spanner\V1\RequestOptions $var
     * @return $this
     */
    public function setRequestOptions($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Spanner\V1\RequestOptions::class);
        $this->request_options = $var;

        return $this;
    }

}

