<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/user_event.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * UserEvent captures all metadata information Retail API needs to know about
 * how end users interact with customers' website.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.UserEvent</code>
 */
class UserEvent extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $event_type = '';
    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $visitor_id = '';
    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     */
    private $event_time = null;
    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     */
    private $experiment_ids;
    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     */
    private $attribution_token = '';
    /**
     * The main product details related to the event.
     * This field is required for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished broswing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished broswing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     */
    private $product_details;
    /**
     * Extra user event features to include in the recommendation model.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * For product recommendation, an example of extra user information is
     * traffic_channel, i.e. how user arrives at the site. Users can arrive
     * at the site by coming to the site directly, or coming through Google
     * search, and etc.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     */
    private $attributes;
    /**
     * The id or name of the associated shopping cart. This id is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     */
    private $cart_id = '';
    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     */
    private $purchase_transaction = null;
    /**
     * The user's search query.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     */
    private $search_query = '';
    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     */
    private $page_categories;
    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     */
    private $user_info = null;
    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     */
    private $uri = '';
    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     */
    private $referrer_uri = '';
    /**
     * A unique id of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     */
    private $page_view_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $event_type
     *           Required. User event type. Allowed values are:
     *           * `add-to-cart`: Products being added to cart.
     *           * `category-page-view`: Special pages such as sale or promotion pages
     *             viewed.
     *           * `detail-page-view`: Products detail page viewed.
     *           * `home-page-view`: Homepage viewed.
     *           * `purchase-complete`: User finishing a purchase.
     *           * `search`: Product search.
     *           * `shopping-cart-page-view`: User viewing a shopping cart.
     *     @type string $visitor_id
     *           Required. A unique identifier for tracking visitors.
     *           For example, this could be implemented with an HTTP cookie, which should be
     *           able to uniquely identify a visitor on a single device. This unique
     *           identifier should not change if the visitor log in/out of the website.
     *           The field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type \Google\Protobuf\Timestamp $event_time
     *           Only required for
     *           [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     *           method. Timestamp of when the user event happened.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $experiment_ids
     *           A list of identifiers for the independent experiment groups this user event
     *           belongs to. This is used to distinguish between user events associated with
     *           different experiment setups (e.g. using Retail API, using different
     *           recommendation models).
     *     @type string $attribution_token
     *           Highly recommended for user events that are the result of
     *           [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     *           This field enables accurate attribution of recommendation model
     *           performance.
     *           The value must be a valid
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           for user events that are the result of
     *           [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     *           This token enables us to accurately attribute page view or purchase back to
     *           the event and the particular predict response containing this
     *           clicked/purchased product. If user clicks on product K in the
     *           recommendation results, pass
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           as a URL parameter to product K's page. When recording events on product
     *           K's page, log the
     *           [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     *           to this field.
     *     @type \Google\Cloud\Retail\V2\ProductDetail[]|\Google\Protobuf\Internal\RepeatedField $product_details
     *           The main product details related to the event.
     *           This field is required for the following event types:
     *           * `add-to-cart`
     *           * `detail-page-view`
     *           * `purchase-complete`
     *           In a `search` event, this field represents the products returned to the end
     *           user on the current page (the end user may have not finished broswing the
     *           whole page yet). When a new page is returned to the end user, after
     *           pagination/filtering/ordering even for the same query, a new `search` event
     *           with different
     *           [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     *           desired. The end user may have not finished broswing the whole page yet.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Extra user event features to include in the recommendation model.
     *           The key must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           For product recommendation, an example of extra user information is
     *           traffic_channel, i.e. how user arrives at the site. Users can arrive
     *           at the site by coming to the site directly, or coming through Google
     *           search, and etc.
     *     @type string $cart_id
     *           The id or name of the associated shopping cart. This id is used
     *           to associate multiple items added or present in the cart before purchase.
     *           This can only be set for `add-to-cart`, `purchase-complete`, or
     *           `shopping-cart-page-view` events.
     *     @type \Google\Cloud\Retail\V2\PurchaseTransaction $purchase_transaction
     *           A transaction represents the entire purchase transaction.
     *           Required for `purchase-complete` events. Other event types should not set
     *           this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string $search_query
     *           The user's search query.
     *           The value must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Required for `search` events. Other event types should not set this field.
     *           Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $page_categories
     *           The categories associated with a category page.
     *           To represent full path of category, use '>' sign to separate different
     *           hierarchies. If '>' is part of the category name, please replace it with
     *           other character(s).
     *           Category pages include special pages such as sales or promotions. For
     *           instance, a special sale page may have the category hierarchy:
     *           "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     *           Required for `category-page-view` events. Other event types should not set
     *           this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type \Google\Cloud\Retail\V2\UserInfo $user_info
     *           User information.
     *     @type string $uri
     *           Complete URL (window.location.href) of the user's current page.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically. Maximum length 5,000
     *           characters.
     *     @type string $referrer_uri
     *           The referrer URL of the current page.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically.
     *     @type string $page_view_id
     *           A unique id of a web page view.
     *           This should be kept the same for all user events triggered from the same
     *           pageview. For example, an item detail page view could trigger multiple
     *           events as the user is browsing the page. The `pageViewId` property should
     *           be kept the same for all these events so that they can be grouped together
     *           properly.
     *           When using the client side event reporting with JavaScript pixel and Google
     *           Tag Manager, this value is filled in automatically.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\UserEvent::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getEventType()
    {
        return $this->event_type;
    }

    /**
     * Required. User event type. Allowed values are:
     * * `add-to-cart`: Products being added to cart.
     * * `category-page-view`: Special pages such as sale or promotion pages
     *   viewed.
     * * `detail-page-view`: Products detail page viewed.
     * * `home-page-view`: Homepage viewed.
     * * `purchase-complete`: User finishing a purchase.
     * * `search`: Product search.
     * * `shopping-cart-page-view`: User viewing a shopping cart.
     *
     * Generated from protobuf field <code>string event_type = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setEventType($var)
    {
        GPBUtil::checkString($var, True);
        $this->event_type = $var;

        return $this;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVisitorId()
    {
        return $this->visitor_id;
    }

    /**
     * Required. A unique identifier for tracking visitors.
     * For example, this could be implemented with an HTTP cookie, which should be
     * able to uniquely identify a visitor on a single device. This unique
     * identifier should not change if the visitor log in/out of the website.
     * The field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string visitor_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVisitorId($var)
    {
        GPBUtil::checkString($var, True);
        $this->visitor_id = $var;

        return $this;
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getEventTime()
    {
        return isset($this->event_time) ? $this->event_time : null;
    }

    public function hasEventTime()
    {
        return isset($this->event_time);
    }

    public function clearEventTime()
    {
        unset($this->event_time);
    }

    /**
     * Only required for
     * [UserEventService.ImportUserEvents][google.cloud.retail.v2.UserEventService.ImportUserEvents]
     * method. Timestamp of when the user event happened.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp event_time = 3;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->event_time = $var;

        return $this;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExperimentIds()
    {
        return $this->experiment_ids;
    }

    /**
     * A list of identifiers for the independent experiment groups this user event
     * belongs to. This is used to distinguish between user events associated with
     * different experiment setups (e.g. using Retail API, using different
     * recommendation models).
     *
     * Generated from protobuf field <code>repeated string experiment_ids = 4;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExperimentIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->experiment_ids = $arr;

        return $this;
    }

    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @return string
     */
    public function getAttributionToken()
    {
        return $this->attribution_token;
    }

    /**
     * Highly recommended for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This field enables accurate attribution of recommendation model
     * performance.
     * The value must be a valid
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * for user events that are the result of
     * [PredictionService.Predict][google.cloud.retail.v2.PredictionService.Predict].
     * This token enables us to accurately attribute page view or purchase back to
     * the event and the particular predict response containing this
     * clicked/purchased product. If user clicks on product K in the
     * recommendation results, pass
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * as a URL parameter to product K's page. When recording events on product
     * K's page, log the
     * [PredictResponse.attribution_token][google.cloud.retail.v2.PredictResponse.attribution_token]
     * to this field.
     *
     * Generated from protobuf field <code>string attribution_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setAttributionToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->attribution_token = $var;

        return $this;
    }

    /**
     * The main product details related to the event.
     * This field is required for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished broswing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished broswing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductDetails()
    {
        return $this->product_details;
    }

    /**
     * The main product details related to the event.
     * This field is required for the following event types:
     * * `add-to-cart`
     * * `detail-page-view`
     * * `purchase-complete`
     * In a `search` event, this field represents the products returned to the end
     * user on the current page (the end user may have not finished broswing the
     * whole page yet). When a new page is returned to the end user, after
     * pagination/filtering/ordering even for the same query, a new `search` event
     * with different
     * [product_details][google.cloud.retail.v2.UserEvent.product_details] is
     * desired. The end user may have not finished broswing the whole page yet.
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.ProductDetail product_details = 6;</code>
     * @param \Google\Cloud\Retail\V2\ProductDetail[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\ProductDetail::class);
        $this->product_details = $arr;

        return $this;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * For product recommendation, an example of extra user information is
     * traffic_channel, i.e. how user arrives at the site. Users can arrive
     * at the site by coming to the site directly, or coming through Google
     * search, and etc.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Extra user event features to include in the recommendation model.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * For product recommendation, an example of extra user information is
     * traffic_channel, i.e. how user arrives at the site. Users can arrive
     * at the site by coming to the site directly, or coming through Google
     * search, and etc.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\CustomAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * The id or name of the associated shopping cart. This id is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     * @return string
     */
    public function getCartId()
    {
        return $this->cart_id;
    }

    /**
     * The id or name of the associated shopping cart. This id is used
     * to associate multiple items added or present in the cart before purchase.
     * This can only be set for `add-to-cart`, `purchase-complete`, or
     * `shopping-cart-page-view` events.
     *
     * Generated from protobuf field <code>string cart_id = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setCartId($var)
    {
        GPBUtil::checkString($var, True);
        $this->cart_id = $var;

        return $this;
    }

    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     * @return \Google\Cloud\Retail\V2\PurchaseTransaction|null
     */
    public function getPurchaseTransaction()
    {
        return isset($this->purchase_transaction) ? $this->purchase_transaction : null;
    }

    public function hasPurchaseTransaction()
    {
        return isset($this->purchase_transaction);
    }

    public function clearPurchaseTransaction()
    {
        unset($this->purchase_transaction);
    }

    /**
     * A transaction represents the entire purchase transaction.
     * Required for `purchase-complete` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PurchaseTransaction purchase_transaction = 9;</code>
     * @param \Google\Cloud\Retail\V2\PurchaseTransaction $var
     * @return $this
     */
    public function setPurchaseTransaction($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\PurchaseTransaction::class);
        $this->purchase_transaction = $var;

        return $this;
    }

    /**
     * The user's search query.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     * @return string
     */
    public function getSearchQuery()
    {
        return $this->search_query;
    }

    /**
     * The user's search query.
     * The value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Required for `search` events. Other event types should not set this field.
     * Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>string search_query = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setSearchQuery($var)
    {
        GPBUtil::checkString($var, True);
        $this->search_query = $var;

        return $this;
    }

    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPageCategories()
    {
        return $this->page_categories;
    }

    /**
     * The categories associated with a category page.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * Category pages include special pages such as sales or promotions. For
     * instance, a special sale page may have the category hierarchy:
     * "pageCategories" : ["Sales > 2017 Black Friday Deals"].
     * Required for `category-page-view` events. Other event types should not set
     * this field. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>repeated string page_categories = 11;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPageCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->page_categories = $arr;

        return $this;
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     * @return \Google\Cloud\Retail\V2\UserInfo|null
     */
    public function getUserInfo()
    {
        return isset($this->user_info) ? $this->user_info : null;
    }

    public function hasUserInfo()
    {
        return isset($this->user_info);
    }

    public function clearUserInfo()
    {
        unset($this->user_info);
    }

    /**
     * User information.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.UserInfo user_info = 12;</code>
     * @param \Google\Cloud\Retail\V2\UserInfo $var
     * @return $this
     */
    public function setUserInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\UserInfo::class);
        $this->user_info = $var;

        return $this;
    }

    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Complete URL (window.location.href) of the user's current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically. Maximum length 5,000
     * characters.
     *
     * Generated from protobuf field <code>string uri = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     * @return string
     */
    public function getReferrerUri()
    {
        return $this->referrer_uri;
    }

    /**
     * The referrer URL of the current page.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string referrer_uri = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setReferrerUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->referrer_uri = $var;

        return $this;
    }

    /**
     * A unique id of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     * @return string
     */
    public function getPageViewId()
    {
        return $this->page_view_id;
    }

    /**
     * A unique id of a web page view.
     * This should be kept the same for all user events triggered from the same
     * pageview. For example, an item detail page view could trigger multiple
     * events as the user is browsing the page. The `pageViewId` property should
     * be kept the same for all these events so that they can be grouped together
     * properly.
     * When using the client side event reporting with JavaScript pixel and Google
     * Tag Manager, this value is filled in automatically.
     *
     * Generated from protobuf field <code>string page_view_id = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setPageViewId($var)
    {
        GPBUtil::checkString($var, True);
        $this->page_view_id = $var;

        return $this;
    }

}

