<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A reservation is a mechanism used to guarantee slots to users.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.reservation.v1.Reservation</code>
 */
class Reservation extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     */
    private $slot_capacity = 0;
    /**
     * If false, any query using this reservation will use idle slots from other
     * reservations within the same admin project. If true, a query using this
     * reservation will execute with the slot capacity specified above at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     */
    private $ignore_idle_slots = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the reservation, e.g.,
     *           `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *     @type int|string $slot_capacity
     *           Minimum slots available to this reservation. A slot is a unit of
     *           computational power in BigQuery, and serves as the unit of parallelism.
     *           Queries using this reservation might use more slots during runtime if
     *           ignore_idle_slots is set to false.
     *           If the new reservation's slot capacity exceed the parent's slot capacity or
     *           if total slot capacity of the new reservation and its siblings exceeds the
     *           parent's slot capacity, the request will fail with
     *           `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *     @type bool $ignore_idle_slots
     *           If false, any query using this reservation will use idle slots from other
     *           reservations within the same admin project. If true, a query using this
     *           reservation will execute with the slot capacity specified above at most.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Reservation\V1\Reservation::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the reservation, e.g.,
     * `projects/&#42;&#47;locations/&#42;&#47;reservations/team1-prod`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @return int|string
     */
    public function getSlotCapacity()
    {
        return $this->slot_capacity;
    }

    /**
     * Minimum slots available to this reservation. A slot is a unit of
     * computational power in BigQuery, and serves as the unit of parallelism.
     * Queries using this reservation might use more slots during runtime if
     * ignore_idle_slots is set to false.
     * If the new reservation's slot capacity exceed the parent's slot capacity or
     * if total slot capacity of the new reservation and its siblings exceeds the
     * parent's slot capacity, the request will fail with
     * `google.rpc.Code.RESOURCE_EXHAUSTED`.
     *
     * Generated from protobuf field <code>int64 slot_capacity = 2;</code>
     * @param int|string $var
     * @return $this
     */
    public function setSlotCapacity($var)
    {
        GPBUtil::checkInt64($var);
        $this->slot_capacity = $var;

        return $this;
    }

    /**
     * If false, any query using this reservation will use idle slots from other
     * reservations within the same admin project. If true, a query using this
     * reservation will execute with the slot capacity specified above at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @return bool
     */
    public function getIgnoreIdleSlots()
    {
        return $this->ignore_idle_slots;
    }

    /**
     * If false, any query using this reservation will use idle slots from other
     * reservations within the same admin project. If true, a query using this
     * reservation will execute with the slot capacity specified above at most.
     *
     * Generated from protobuf field <code>bool ignore_idle_slots = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setIgnoreIdleSlots($var)
    {
        GPBUtil::checkBool($var);
        $this->ignore_idle_slots = $var;

        return $this;
    }

}

