<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/datatransfer/v1/datasource.proto

namespace Google\Cloud\BigQuery\DataTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the data source definition.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.datatransfer.v1.DataSourceDefinition</code>
 */
class DataSourceDefinition extends \Google\Protobuf\Internal\Message
{
    /**
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     *
     * Generated from protobuf field <code>string name = 21;</code>
     */
    private $name = '';
    /**
     * Data source metadata.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     */
    private $data_source = null;
    /**
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     *
     * Generated from protobuf field <code>string transfer_run_pubsub_topic = 13;</code>
     */
    private $transfer_run_pubsub_topic = '';
    /**
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration run_time_offset = 16;</code>
     */
    private $run_time_offset = null;
    /**
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     *
     * Generated from protobuf field <code>string support_email = 22;</code>
     */
    private $support_email = '';
    /**
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     *
     * Generated from protobuf field <code>string service_account = 2;</code>
     */
    private $service_account = '';
    /**
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     */
    private $disabled = false;
    /**
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     *
     * Generated from protobuf field <code>string transfer_config_pubsub_topic = 12;</code>
     */
    private $transfer_config_pubsub_topic = '';
    /**
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     *
     * Generated from protobuf field <code>repeated string supported_location_ids = 23;</code>
     */
    private $supported_location_ids;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The resource name of the data source definition.
     *           Data source definition names have the form
     *           `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\DataSource $data_source
     *           Data source metadata.
     *     @type string $transfer_run_pubsub_topic
     *           The Pub/Sub topic to be used for broadcasting a message when a transfer run
     *           is created. Both this topic and transfer_config_pubsub_topic can be
     *           set to a custom topic. By default, both topics are auto-generated if none
     *           of them is provided when creating the definition. However, if one topic is
     *           manually set, the other topic has to be manually set as well. The only
     *           difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     *           topic, but transfer_config_pubsub_topic can be set to empty. The comments
     *           about "{location}" for transfer_config_pubsub_topic apply here too.
     *     @type \Google\Protobuf\Duration $run_time_offset
     *           Duration which should be added to schedule_time to calculate
     *           run_time when job is scheduled. Only applicable for automatically
     *           scheduled transfer runs. Used to start a run early on a data source that
     *           supports continuous data refresh to compensate for unknown timezone
     *           offsets. Use a negative number to start a run late for data sources not
     *           supporting continuous data refresh.
     *     @type string $support_email
     *           Support e-mail address of the OAuth client's Brand, which contains the
     *           consent screen data.
     *     @type string $service_account
     *           When service account is specified, BigQuery will share created dataset
     *           with the given service account. Also, this service account will be
     *           eligible to perform status updates and message logging for data transfer
     *           runs for the corresponding data_source_id.
     *     @type bool $disabled
     *           Is data source disabled? If true, data_source is not visible.
     *           API will also stop returning any data transfer configs and/or runs
     *           associated with the data source. This setting has higher priority
     *           than whitelisted_project_ids.
     *     @type string $transfer_config_pubsub_topic
     *           The Pub/Sub topic to use for broadcasting a message for transfer config. If
     *           empty, a message will not be broadcasted. Both this topic and
     *           transfer_run_pubsub_topic are auto-generated if none of them is provided
     *           when creating the definition. It is recommended to provide
     *           transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     *           provided. Otherwise, it will be set to empty. If "{location}" is found in
     *           the value, then that means, data source wants to handle message separately
     *           for datasets in different regions. We will replace {location} with the
     *           actual dataset location, as the actual topic name. For example,
     *           projects/connector/topics/scheduler-{location} could become
     *           projects/connector/topics/scheduler-us. If "{location}" is not found, then
     *           we will use the input value as topic name.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $supported_location_ids
     *           Supported location_ids used for deciding in which locations Pub/Sub topics
     *           need to be created. If custom Pub/Sub topics are used and they contains
     *           '{location}', the location_ids will be used for validating the topics by
     *           replacing the '{location}' with the individual location in the list. The
     *           valid values are the "location_id" field of the response of `GET
     *           https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     *           In addition, if the data source needs to support all available regions,
     *           supported_location_ids can be set to "global" (a single string element).
     *           When "global" is specified:
     *           1) the data source implementation is supposed to stage the data in proper
     *           region of the destination dataset;
     *           2) Data source developer should be aware of the implications (e.g., network
     *           traffic latency, potential charge associated with cross-region traffic,
     *           etc.) of supporting the "global" region;
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Datatransfer\V1\Datasource::initOnce();
        parent::__construct($data);
    }

    /**
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     *
     * Generated from protobuf field <code>string name = 21;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource name of the data source definition.
     * Data source definition names have the form
     * `projects/{project_id}/locations/{location}/dataSourceDefinitions/{data_source_id}`.
     *
     * Generated from protobuf field <code>string name = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Data source metadata.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\DataSource
     */
    public function getDataSource()
    {
        return $this->data_source;
    }

    /**
     * Data source metadata.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource data_source = 1;</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\DataSource $var
     * @return $this
     */
    public function setDataSource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\DataTransfer\V1\DataSource::class);
        $this->data_source = $var;

        return $this;
    }

    /**
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     *
     * Generated from protobuf field <code>string transfer_run_pubsub_topic = 13;</code>
     * @return string
     */
    public function getTransferRunPubsubTopic()
    {
        return $this->transfer_run_pubsub_topic;
    }

    /**
     * The Pub/Sub topic to be used for broadcasting a message when a transfer run
     * is created. Both this topic and transfer_config_pubsub_topic can be
     * set to a custom topic. By default, both topics are auto-generated if none
     * of them is provided when creating the definition. However, if one topic is
     * manually set, the other topic has to be manually set as well. The only
     * difference is that transfer_run_pubsub_topic must be a non-empty Pub/Sub
     * topic, but transfer_config_pubsub_topic can be set to empty. The comments
     * about "{location}" for transfer_config_pubsub_topic apply here too.
     *
     * Generated from protobuf field <code>string transfer_run_pubsub_topic = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setTransferRunPubsubTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->transfer_run_pubsub_topic = $var;

        return $this;
    }

    /**
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration run_time_offset = 16;</code>
     * @return \Google\Protobuf\Duration
     */
    public function getRunTimeOffset()
    {
        return $this->run_time_offset;
    }

    /**
     * Duration which should be added to schedule_time to calculate
     * run_time when job is scheduled. Only applicable for automatically
     * scheduled transfer runs. Used to start a run early on a data source that
     * supports continuous data refresh to compensate for unknown timezone
     * offsets. Use a negative number to start a run late for data sources not
     * supporting continuous data refresh.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration run_time_offset = 16;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setRunTimeOffset($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->run_time_offset = $var;

        return $this;
    }

    /**
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     *
     * Generated from protobuf field <code>string support_email = 22;</code>
     * @return string
     */
    public function getSupportEmail()
    {
        return $this->support_email;
    }

    /**
     * Support e-mail address of the OAuth client's Brand, which contains the
     * consent screen data.
     *
     * Generated from protobuf field <code>string support_email = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setSupportEmail($var)
    {
        GPBUtil::checkString($var, True);
        $this->support_email = $var;

        return $this;
    }

    /**
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     *
     * Generated from protobuf field <code>string service_account = 2;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * When service account is specified, BigQuery will share created dataset
     * with the given service account. Also, this service account will be
     * eligible to perform status updates and message logging for data transfer
     * runs for the corresponding data_source_id.
     *
     * Generated from protobuf field <code>string service_account = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @return bool
     */
    public function getDisabled()
    {
        return $this->disabled;
    }

    /**
     * Is data source disabled? If true, data_source is not visible.
     * API will also stop returning any data transfer configs and/or runs
     * associated with the data source. This setting has higher priority
     * than whitelisted_project_ids.
     *
     * Generated from protobuf field <code>bool disabled = 5;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->disabled = $var;

        return $this;
    }

    /**
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     *
     * Generated from protobuf field <code>string transfer_config_pubsub_topic = 12;</code>
     * @return string
     */
    public function getTransferConfigPubsubTopic()
    {
        return $this->transfer_config_pubsub_topic;
    }

    /**
     * The Pub/Sub topic to use for broadcasting a message for transfer config. If
     * empty, a message will not be broadcasted. Both this topic and
     * transfer_run_pubsub_topic are auto-generated if none of them is provided
     * when creating the definition. It is recommended to provide
     * transfer_config_pubsub_topic if a user-owned transfer_run_pubsub_topic is
     * provided. Otherwise, it will be set to empty. If "{location}" is found in
     * the value, then that means, data source wants to handle message separately
     * for datasets in different regions. We will replace {location} with the
     * actual dataset location, as the actual topic name. For example,
     * projects/connector/topics/scheduler-{location} could become
     * projects/connector/topics/scheduler-us. If "{location}" is not found, then
     * we will use the input value as topic name.
     *
     * Generated from protobuf field <code>string transfer_config_pubsub_topic = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setTransferConfigPubsubTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->transfer_config_pubsub_topic = $var;

        return $this;
    }

    /**
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     *
     * Generated from protobuf field <code>repeated string supported_location_ids = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSupportedLocationIds()
    {
        return $this->supported_location_ids;
    }

    /**
     * Supported location_ids used for deciding in which locations Pub/Sub topics
     * need to be created. If custom Pub/Sub topics are used and they contains
     * '{location}', the location_ids will be used for validating the topics by
     * replacing the '{location}' with the individual location in the list. The
     * valid values are the "location_id" field of the response of `GET
     * https://bigquerydatatransfer.googleapis.com/v1/{name=projects/&#42;}/locations`
     * In addition, if the data source needs to support all available regions,
     * supported_location_ids can be set to "global" (a single string element).
     * When "global" is specified:
     * 1) the data source implementation is supposed to stage the data in proper
     * region of the destination dataset;
     * 2) Data source developer should be aware of the implications (e.g., network
     * traffic latency, potential charge associated with cross-region traffic,
     * etc.) of supporting the "global" region;
     *
     * Generated from protobuf field <code>repeated string supported_location_ids = 23;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSupportedLocationIds($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->supported_location_ids = $arr;

        return $this;
    }

}

