<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

namespace Google\Cloud\BigQuery\DataTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents data source metadata. Metadata is sufficient to
 * render UI and request proper OAuth tokens.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.datatransfer.v1.DataSource</code>
 */
class DataSource extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. Data source resource name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $name = '';
    /**
     * Data source id.
     *
     * Generated from protobuf field <code>string data_source_id = 2;</code>
     */
    private $data_source_id = '';
    /**
     * User friendly data source name.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     */
    private $display_name = '';
    /**
     * User friendly data source description string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     */
    private $description = '';
    /**
     * Data source client id which should be used to receive refresh token.
     *
     * Generated from protobuf field <code>string client_id = 5;</code>
     */
    private $client_id = '';
    /**
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     *
     * Generated from protobuf field <code>repeated string scopes = 6;</code>
     */
    private $scopes;
    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];</code>
     * @deprecated
     */
    protected $transfer_type = 0;
    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     * @deprecated
     */
    protected $supports_multiple_transfers = false;
    /**
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     *
     * Generated from protobuf field <code>int32 update_deadline_seconds = 9;</code>
     */
    private $update_deadline_seconds = 0;
    /**
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     *
     * Generated from protobuf field <code>string default_schedule = 10;</code>
     */
    private $default_schedule = '';
    /**
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     *
     * Generated from protobuf field <code>bool supports_custom_schedule = 11;</code>
     */
    private $supports_custom_schedule = false;
    /**
     * Data source parameters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;</code>
     */
    private $parameters;
    /**
     * Url for the help document for this data source.
     *
     * Generated from protobuf field <code>string help_url = 13;</code>
     */
    private $help_url = '';
    /**
     * Indicates the type of authorization.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;</code>
     */
    private $authorization_type = 0;
    /**
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;</code>
     */
    private $data_refresh_type = 0;
    /**
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     *
     * Generated from protobuf field <code>int32 default_data_refresh_window_days = 16;</code>
     */
    private $default_data_refresh_window_days = 0;
    /**
     * Disables backfilling and manual run scheduling
     * for the data source.
     *
     * Generated from protobuf field <code>bool manual_runs_disabled = 17;</code>
     */
    private $manual_runs_disabled = false;
    /**
     * The minimum interval for scheduler to schedule runs.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     */
    private $minimum_schedule_interval = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. Data source resource name.
     *     @type string $data_source_id
     *           Data source id.
     *     @type string $display_name
     *           User friendly data source name.
     *     @type string $description
     *           User friendly data source description string.
     *     @type string $client_id
     *           Data source client id which should be used to receive refresh token.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $scopes
     *           Api auth scopes for which refresh token needs to be obtained. These are
     *           scopes needed by a data source to prepare data and ingest them into
     *           BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     *     @type int $transfer_type
     *           Deprecated. This field has no effect.
     *     @type bool $supports_multiple_transfers
     *           Deprecated. This field has no effect.
     *     @type int $update_deadline_seconds
     *           The number of seconds to wait for an update from the data source
     *           before the Data Transfer Service marks the transfer as FAILED.
     *     @type string $default_schedule
     *           Default data transfer schedule.
     *           Examples of valid schedules include:
     *           `1st,3rd monday of month 15:30`,
     *           `every wed,fri of jan,jun 13:15`, and
     *           `first sunday of quarter 00:00`.
     *     @type bool $supports_custom_schedule
     *           Specifies whether the data source supports a user defined schedule, or
     *           operates on the default schedule.
     *           When set to `true`, user can override default schedule.
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\DataSourceParameter[]|\Google\Protobuf\Internal\RepeatedField $parameters
     *           Data source parameters.
     *     @type string $help_url
     *           Url for the help document for this data source.
     *     @type int $authorization_type
     *           Indicates the type of authorization.
     *     @type int $data_refresh_type
     *           Specifies whether the data source supports automatic data refresh for the
     *           past few days, and how it's supported.
     *           For some data sources, data might not be complete until a few days later,
     *           so it's useful to refresh data automatically.
     *     @type int $default_data_refresh_window_days
     *           Default data refresh window on days.
     *           Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     *     @type bool $manual_runs_disabled
     *           Disables backfilling and manual run scheduling
     *           for the data source.
     *     @type \Google\Protobuf\Duration $minimum_schedule_interval
     *           The minimum interval for scheduler to schedule runs.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Datatransfer\V1\Datatransfer::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. Data source resource name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. Data source resource name.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Data source id.
     *
     * Generated from protobuf field <code>string data_source_id = 2;</code>
     * @return string
     */
    public function getDataSourceId()
    {
        return $this->data_source_id;
    }

    /**
     * Data source id.
     *
     * Generated from protobuf field <code>string data_source_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setDataSourceId($var)
    {
        GPBUtil::checkString($var, True);
        $this->data_source_id = $var;

        return $this;
    }

    /**
     * User friendly data source name.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * User friendly data source name.
     *
     * Generated from protobuf field <code>string display_name = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * User friendly data source description string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User friendly data source description string.
     *
     * Generated from protobuf field <code>string description = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Data source client id which should be used to receive refresh token.
     *
     * Generated from protobuf field <code>string client_id = 5;</code>
     * @return string
     */
    public function getClientId()
    {
        return $this->client_id;
    }

    /**
     * Data source client id which should be used to receive refresh token.
     *
     * Generated from protobuf field <code>string client_id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setClientId($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_id = $var;

        return $this;
    }

    /**
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     *
     * Generated from protobuf field <code>repeated string scopes = 6;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getScopes()
    {
        return $this->scopes;
    }

    /**
     * Api auth scopes for which refresh token needs to be obtained. These are
     * scopes needed by a data source to prepare data and ingest them into
     * BigQuery, e.g., https://www.googleapis.com/auth/bigquery
     *
     * Generated from protobuf field <code>repeated string scopes = 6;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setScopes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->scopes = $arr;

        return $this;
    }

    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];</code>
     * @return int
     * @deprecated
     */
    public function getTransferType()
    {
        @trigger_error('transfer_type is deprecated.', E_USER_DEPRECATED);
        return $this->transfer_type;
    }

    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TransferType transfer_type = 7 [deprecated = true];</code>
     * @param int $var
     * @return $this
     * @deprecated
     */
    public function setTransferType($var)
    {
        @trigger_error('transfer_type is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\DataTransfer\V1\TransferType::class);
        $this->transfer_type = $var;

        return $this;
    }

    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getSupportsMultipleTransfers()
    {
        @trigger_error('supports_multiple_transfers is deprecated.', E_USER_DEPRECATED);
        return $this->supports_multiple_transfers;
    }

    /**
     * Deprecated. This field has no effect.
     *
     * Generated from protobuf field <code>bool supports_multiple_transfers = 8 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setSupportsMultipleTransfers($var)
    {
        @trigger_error('supports_multiple_transfers is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->supports_multiple_transfers = $var;

        return $this;
    }

    /**
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     *
     * Generated from protobuf field <code>int32 update_deadline_seconds = 9;</code>
     * @return int
     */
    public function getUpdateDeadlineSeconds()
    {
        return $this->update_deadline_seconds;
    }

    /**
     * The number of seconds to wait for an update from the data source
     * before the Data Transfer Service marks the transfer as FAILED.
     *
     * Generated from protobuf field <code>int32 update_deadline_seconds = 9;</code>
     * @param int $var
     * @return $this
     */
    public function setUpdateDeadlineSeconds($var)
    {
        GPBUtil::checkInt32($var);
        $this->update_deadline_seconds = $var;

        return $this;
    }

    /**
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     *
     * Generated from protobuf field <code>string default_schedule = 10;</code>
     * @return string
     */
    public function getDefaultSchedule()
    {
        return $this->default_schedule;
    }

    /**
     * Default data transfer schedule.
     * Examples of valid schedules include:
     * `1st,3rd monday of month 15:30`,
     * `every wed,fri of jan,jun 13:15`, and
     * `first sunday of quarter 00:00`.
     *
     * Generated from protobuf field <code>string default_schedule = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setDefaultSchedule($var)
    {
        GPBUtil::checkString($var, True);
        $this->default_schedule = $var;

        return $this;
    }

    /**
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     *
     * Generated from protobuf field <code>bool supports_custom_schedule = 11;</code>
     * @return bool
     */
    public function getSupportsCustomSchedule()
    {
        return $this->supports_custom_schedule;
    }

    /**
     * Specifies whether the data source supports a user defined schedule, or
     * operates on the default schedule.
     * When set to `true`, user can override default schedule.
     *
     * Generated from protobuf field <code>bool supports_custom_schedule = 11;</code>
     * @param bool $var
     * @return $this
     */
    public function setSupportsCustomSchedule($var)
    {
        GPBUtil::checkBool($var);
        $this->supports_custom_schedule = $var;

        return $this;
    }

    /**
     * Data source parameters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    /**
     * Data source parameters.
     *
     * Generated from protobuf field <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter parameters = 12;</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\DataSourceParameter[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setParameters($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\BigQuery\DataTransfer\V1\DataSourceParameter::class);
        $this->parameters = $arr;

        return $this;
    }

    /**
     * Url for the help document for this data source.
     *
     * Generated from protobuf field <code>string help_url = 13;</code>
     * @return string
     */
    public function getHelpUrl()
    {
        return $this->help_url;
    }

    /**
     * Url for the help document for this data source.
     *
     * Generated from protobuf field <code>string help_url = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setHelpUrl($var)
    {
        GPBUtil::checkString($var, True);
        $this->help_url = $var;

        return $this;
    }

    /**
     * Indicates the type of authorization.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;</code>
     * @return int
     */
    public function getAuthorizationType()
    {
        return $this->authorization_type;
    }

    /**
     * Indicates the type of authorization.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.AuthorizationType authorization_type = 14;</code>
     * @param int $var
     * @return $this
     */
    public function setAuthorizationType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\DataTransfer\V1\DataSource\AuthorizationType::class);
        $this->authorization_type = $var;

        return $this;
    }

    /**
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;</code>
     * @return int
     */
    public function getDataRefreshType()
    {
        return $this->data_refresh_type;
    }

    /**
     * Specifies whether the data source supports automatic data refresh for the
     * past few days, and how it's supported.
     * For some data sources, data might not be complete until a few days later,
     * so it's useful to refresh data automatically.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.DataSource.DataRefreshType data_refresh_type = 15;</code>
     * @param int $var
     * @return $this
     */
    public function setDataRefreshType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\DataTransfer\V1\DataSource\DataRefreshType::class);
        $this->data_refresh_type = $var;

        return $this;
    }

    /**
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     *
     * Generated from protobuf field <code>int32 default_data_refresh_window_days = 16;</code>
     * @return int
     */
    public function getDefaultDataRefreshWindowDays()
    {
        return $this->default_data_refresh_window_days;
    }

    /**
     * Default data refresh window on days.
     * Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
     *
     * Generated from protobuf field <code>int32 default_data_refresh_window_days = 16;</code>
     * @param int $var
     * @return $this
     */
    public function setDefaultDataRefreshWindowDays($var)
    {
        GPBUtil::checkInt32($var);
        $this->default_data_refresh_window_days = $var;

        return $this;
    }

    /**
     * Disables backfilling and manual run scheduling
     * for the data source.
     *
     * Generated from protobuf field <code>bool manual_runs_disabled = 17;</code>
     * @return bool
     */
    public function getManualRunsDisabled()
    {
        return $this->manual_runs_disabled;
    }

    /**
     * Disables backfilling and manual run scheduling
     * for the data source.
     *
     * Generated from protobuf field <code>bool manual_runs_disabled = 17;</code>
     * @param bool $var
     * @return $this
     */
    public function setManualRunsDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->manual_runs_disabled = $var;

        return $this;
    }

    /**
     * The minimum interval for scheduler to schedule runs.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMinimumScheduleInterval()
    {
        return isset($this->minimum_schedule_interval) ? $this->minimum_schedule_interval : null;
    }

    public function hasMinimumScheduleInterval()
    {
        return isset($this->minimum_schedule_interval);
    }

    public function clearMinimumScheduleInterval()
    {
        unset($this->minimum_schedule_interval);
    }

    /**
     * The minimum interval for scheduler to schedule runs.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration minimum_schedule_interval = 18;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMinimumScheduleInterval($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->minimum_schedule_interval = $var;

        return $this;
    }

}

